//
//  GSPartProperty.h
//  GlyphsCore
//
//  Created by Georg Seifert on 29.09.14.
//  Copyright (c) 2014 schriftgestaltung.de. All rights reserved.
//

#import "GSContainerProtocol.h"
#import <Foundation/Foundation.h>
#import <GlyphsCore/GSBase.h>

/**
 The class implementing the properties in Smart Glyphs.

 See also: [GSGlyph.partsSettings]([GSGlyph partsSettings])
 */
@interface GSPartProperty : NSObject

/// @name Initialisation

/** Initialize the object with a dictionary

 @param dict The content of the dict as it is saved to the .glyphs file

 The dict may look like this:

	{
		bottomValue = 40;
		name = Width;
		topValue = 100;
	}

 @return a new instance

 @see propertyList
 */
- (instancetype)initWithDict:(NSDictionary *)dict;

- (instancetype)initWithName:(NSString *)name bottom:(int)bottom top:(int)top;

/** The content of the object serialalued as a dictionary.

 The dict has a format like this:

	{
		bottomValue = 40;
		name = Width;
		topValue = 100;
	}
 @param format the version
 @return a dict

 @see initWithDict:
 */
- (NSDictionary *)propertyListValueFormat:(GSFormatVersion)format;

//* @name Values

/// The name of the property
@property (strong, nonatomic) NSString *name;

/** A id to use as key in the piece-settings in the components

 this allows to change the name and not loose the settings
 */
@property (strong, nonatomic) NSString *axisId;

/** The name of the bottom value

 This is currently not used, so ignore it.
 */
@property (strong, nonatomic) NSString *bottomName;

/// The lower value for the interpolation range
@property (assign, nonatomic) NSInteger bottomValue;

/** The name of the top value

 This is currently not used, so ignore it.
 */
@property (strong, nonatomic) NSString *topName;
/// The upper value for the interpolation range
@property (assign, nonatomic) NSInteger topValue;
@property (assign, nonatomic) CGFloat pieceValue;

- (CGFloat)valueForPartSetting:(NSNumber *)part;

@property (weak, nonatomic) GSContainer *pieceComponent;

#ifndef GLYPHS_VIEWER
- (BOOL)saveToFile:(FILE *)file format:(GSFormatVersion)formatVersion error:(NSError **)error;
#endif

@end
